<?php

/**
 * Tüm Bakiyeleri Yeniden Hesapla
 */

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/balance_manager.php';

// Web'den çalıştırılıyorsa
if (php_sapi_name() !== 'cli') {
    echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Bakiye Yeniden Hesaplama</title>";
    echo "<style>body{font-family:monospace;padding:20px;background:#f5f5f5;}";
    echo ".success{color:green;}.error{color:red;}.info{color:blue;}</style></head><body>";
    echo "<h2>Tüm Bakiyeleri Yeniden Hesapla</h2><pre>";
}

echo "==============================================\n";
echo "  TÜM BAKİYELERİ YENİDEN HESAPLA\n";
echo "==============================================\n\n";

try {
    $database = Database::getInstance();
    $balanceManager = new BalanceManager($database);
    
    // Tüm carileri al
    $sql = "SELECT cari_id, firma_adi, cari_tipi FROM cariler ORDER BY cari_id";
    $cariler = $database->fetchAll($sql);
    
    echo "Toplam " . count($cariler) . " cari bulundu.\n\n";
    echo "Bakiyeler yeniden hesaplanıyor...\n";
    echo "---------------------------------------------\n";
    
    $successCount = 0;
    $errorCount = 0;
    
    foreach ($cariler as $cari) {
        try {
            // Bakiyeyi hesapla
            $calculated = $balanceManager->calculateBalance($cari['cari_id']);
            
            // Güncelle
            $sql = "UPDATE cariler SET cari_bakiye = ?, bakiye = ? WHERE cari_id = ?";
            $database->execute($sql, [$calculated, $calculated, $cari['cari_id']]);
            
            echo "✓ Cari ID {$cari['cari_id']} - {$cari['firma_adi']}: " . number_format($calculated, 2) . " TL\n";
            $successCount++;
            
        } catch (Exception $e) {
            echo "✗ Cari ID {$cari['cari_id']} - Hata: " . $e->getMessage() . "\n";
            $errorCount++;
        }
    }
    
    echo "\n==============================================\n";
    echo "  ÖZET\n";
    echo "==============================================\n";
    echo "Başarılı: $successCount\n";
    echo "Hata: $errorCount\n";
    echo "Toplam: " . count($cariler) . "\n\n";
    
    if ($errorCount == 0) {
        echo "✓ TÜM BAKİYELER BAŞARIYLA YENİDEN HESAPLANDI!\n\n";
    } else {
        echo "⚠ Bazı bakiyeler hesaplanamadı!\n\n";
    }
    
} catch (Exception $e) {
    echo "\nHATA: " . $e->getMessage() . "\n\n";
    exit(1);
}

if (php_sapi_name() !== 'cli') {
    echo "</pre>";
    echo "<br><a href='../admin/database_analysis.php'>Veritabanı Analizi</a> | ";
    echo "<a href='../admin/system_test.php'>Sistem Testi</a>";
    echo "</body></html>";
}

?>
