<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sunucu Hatası - Depo Stok Takip</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .error-container {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 3rem;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            text-align: center;
            max-width: 600px;
            width: 90%;
        }
        .error-icon {
            font-size: 5rem;
            color: #dc3545;
            margin-bottom: 1rem;
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        .error-code {
            font-size: 4rem;
            font-weight: bold;
            color: #495057;
            margin-bottom: 1rem;
        }
        .error-message {
            font-size: 1.2rem;
            color: #6c757d;
            margin-bottom: 2rem;
            line-height: 1.6;
        }
        .btn-home {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border: none;
            padding: 12px 30px;
            border-radius: 50px;
            color: white;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            display: inline-block;
        }
        .btn-home:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
            color: white;
        }
        .error-details {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1rem;
            margin-top: 2rem;
            font-size: 0.9rem;
            color: #6c757d;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-icon">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        
        <div class="error-code">500</div>
        
        <h2 class="mb-3">Sunucu Hatası</h2>
        
        <div class="error-message">
            Üzgünüz, sunucuda beklenmeyen bir hata oluştu. 
            <br>
            Teknik ekibimiz bu sorunla ilgili bilgilendirildi ve en kısa sürede çözülecek.
        </div>
        
        <div class="d-flex justify-content-center gap-3 flex-wrap">
            <a href="javascript:history.back()" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Geri Dön
            </a>
            <a href="/mulakat/pages/dashboard.php" class="btn-home">
                <i class="fas fa-home me-2"></i>Ana Sayfaya Dön
            </a>
            <button onclick="location.reload()" class="btn btn-outline-primary">
                <i class="fas fa-redo me-2"></i>Sayfayı Yenile
            </button>
        </div>
        
        <div class="error-details">
            <strong>Ne yapabilirsiniz?</strong>
            <ul class="list-unstyled mt-2 mb-0">
                <li><i class="fas fa-check-circle text-success me-2"></i>Sayfayı yenilemeyi deneyin</li>
                <li><i class="fas fa-check-circle text-success me-2"></i>Birkaç dakika sonra tekrar deneyin</li>
                <li><i class="fas fa-check-circle text-success me-2"></i>Sorun devam ederse sistem yöneticisine başvurun</li>
            </ul>
        </div>
        
        <div class="mt-4">
            <small class="text-muted">
                Hata Kodu: <?= uniqid('ERR_') ?> | 
                Zaman: <?= date('d.m.Y H:i:s') ?>
            </small>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        
        console.error('500 Internal Server Error occurred at:', new Date().toISOString());
    </script>
</body>
</html>

