<?php
require_once '../config/config.php';
require_once '../includes/security.php';
require_once '../includes/authorization.php';
require_once '../config/database.php';

requireLogin();

Authorization::requirePageAccess('dashboard', 'okuma');

$user_id = $_SESSION['user_id'];
$username = $_SESSION['username'];

try {
    $stats = [];
    
    $sql = "SELECT COUNT(*) as toplam FROM urunler";
    $result = $database->fetch($sql);
    $stats['toplam_urun'] = $result['toplam'] ?? 0;
    
    $sql = "SELECT SUM(stok_miktari * alis_fiyati) as toplam_deger FROM urunler";
    $result = $database->fetch($sql);
    $stats['toplam_stok_degeri'] = $result['toplam_deger'] ?? 0;
    
    $sql = "SELECT COUNT(*) as toplam FROM cariler";
    $result = $database->fetch($sql);
    $stats['toplam_cari'] = $result['toplam'] ?? 0;
    
    // Net bakiye hesaplama (müşteri alacakları - tedarikçi borçları)
    $sql = "SELECT 
                SUM(CASE WHEN cari_tipi = 'musteri' AND cari_bakiye > 0 THEN cari_bakiye ELSE 0 END) as musteri_alacak,
                SUM(CASE WHEN cari_tipi = 'tedarikci' AND cari_bakiye > 0 THEN cari_bakiye ELSE 0 END) as tedarikci_borc
            FROM cariler";
    $result = $database->fetch($sql);
    $stats['musteri_alacak'] = $result['musteri_alacak'] ?? 0;
    $stats['tedarikci_borc'] = $result['tedarikci_borc'] ?? 0;
    $stats['net_bakiye'] = $stats['musteri_alacak'] - $stats['tedarikci_borc'];
    
    // Borcumuzun olduğu tedarikçi sayısı
    $sql = "SELECT COUNT(*) as borclu_tedarikci FROM cariler WHERE cari_tipi = 'tedarikci' AND cari_bakiye > 0";
    $result = $database->fetch($sql);
    $stats['borclu_tedarikci'] = $result['borclu_tedarikci'] ?? 0;
    
    $sql = "SELECT COUNT(*) as toplam FROM urunler WHERE stok_miktari < 10";
    $result = $database->fetch($sql);
    $stats['dusuk_stok'] = $result['toplam'] ?? 0;
    
    $sql = "SELECT s.satis_id, s.satis_tarihi, s.toplam_tutar, c.firma_adi 
            FROM satislar s 
            JOIN cariler c ON s.cari_id = c.cari_id 
            ORDER BY s.satis_tarihi DESC 
            LIMIT 5";
    $son_satislar = $database->fetchAll($sql);
    
} catch (Exception $e) {
    $error_message = "Veriler yüklenirken hata oluştu: " . $e->getMessage();
}
?>
<?php include '../includes/header.php'; ?>
    <style>
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 1.5rem;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
            border-left: 4px solid;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.15);
        }
        .stat-card.primary { border-left-color: #667eea; }
        .stat-card.success { border-left-color: #28a745; }
        .stat-card.warning { border-left-color: #ffc107; }
        .stat-card.danger { border-left-color: #dc3545; }
        .stat-card.info { border-left-color: #17a2b8; }
        
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: white;
        }
        .stat-icon.primary { background: #667eea; }
        .stat-icon.success { background: #28a745; }
        .stat-icon.warning { background: #ffc107; }
        .stat-icon.danger { background: #dc3545; }
        .stat-icon.info { background: #17a2b8; }
        

    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>

    
    <div class="main-content" id="mainContent">
        
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><i class="fas fa-tachometer-alt me-2"></i>Dashboard</h2>
            <span class="text-muted">
                Hoş geldin, <?php echo Security::escapeOutput($username); ?>
                <?php 
                $user_info = Authorization::getNavbarUserInfo();
                if ($user_info['role_name']) {
                    echo ' (' . Security::escapeOutput($user_info['role_name']) . ')';
                }
                ?>
            </span>
        </div>

        
        <div class="container-fluid">
            <?php if (isset($error_message)): ?>
                <div class="alert alert-danger" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <?php echo Security::escapeOutput($error_message); ?>
                </div>
            <?php endif; ?>

            
            <div class="row mb-4">
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="stat-card primary">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon primary">
                                <i class="fas fa-boxes"></i>
                            </div>
                            <div class="ms-3">
                                <h3 class="mb-0"><?php echo number_format($stats['toplam_urun']); ?></h3>
                                <p class="text-muted mb-0">Toplam Ürün</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="stat-card success">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon success">
                                <i class="fas fa-lira-sign"></i>
                            </div>
                            <div class="ms-3">
                                <h3 class="mb-0">₺<?php echo number_format($stats['toplam_stok_degeri'], 2); ?></h3>
                                <p class="text-muted mb-0">Stok Değeri</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="stat-card info">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon info">
                                <i class="fas fa-users"></i>
                            </div>
                            <div class="ms-3">
                                <h3 class="mb-0"><?php echo number_format($stats['toplam_cari']); ?></h3>
                                <p class="text-muted mb-0">Toplam Cari</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="stat-card <?php echo $stats['dusuk_stok'] > 0 ? 'danger' : 'warning'; ?>">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon <?php echo $stats['dusuk_stok'] > 0 ? 'danger' : 'warning'; ?>">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                            <div class="ms-3">
                                <h3 class="mb-0"><?php echo number_format($stats['dusuk_stok']); ?></h3>
                                <p class="text-muted mb-0">Düşük Stok</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="row mb-4">
                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="stat-card success">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon success">
                                <i class="fas fa-hand-holding-usd"></i>
                            </div>
                            <div class="ms-3">
                                <h3 class="mb-0">₺<?php echo number_format($stats['musteri_alacak'], 2); ?></h3>
                                <p class="text-muted mb-0">Müşteri Alacakları</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="stat-card <?php echo $stats['tedarikci_borc'] > 0 ? 'danger' : 'warning'; ?>">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon <?php echo $stats['tedarikci_borc'] > 0 ? 'danger' : 'warning'; ?>">
                                <i class="fas fa-credit-card"></i>
                            </div>
                            <div class="ms-3">
                                <h3 class="mb-0">₺<?php echo number_format($stats['tedarikci_borc'], 2); ?></h3>
                                <p class="text-muted mb-0">Tedarikçilere Olan Borçlar</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="stat-card <?php echo $stats['borclu_tedarikci'] > 0 ? 'warning' : 'info'; ?>">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon <?php echo $stats['borclu_tedarikci'] > 0 ? 'warning' : 'info'; ?>">
                                <i class="fas fa-truck"></i>
                            </div>
                            <div class="ms-3">
                                <h3 class="mb-0"><?php echo number_format($stats['borclu_tedarikci']); ?></h3>
                                <p class="text-muted mb-0">Borcumuz Olan Tedarikçi</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-4">
                    <div class="stat-card <?php echo $stats['net_bakiye'] >= 0 ? 'success' : 'danger'; ?>">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon <?php echo $stats['net_bakiye'] >= 0 ? 'success' : 'danger'; ?>">
                                <i class="fas fa-balance-scale"></i>
                            </div>
                            <div class="ms-3">
                                <h3 class="mb-0">₺<?php echo number_format($stats['net_bakiye'], 2); ?></h3>
                                <p class="text-muted mb-0">Net Bakiye</p>
                                <small class="text-muted">
                                    <?php echo $stats['net_bakiye'] >= 0 ? 'Pozitif' : 'Negatif'; ?> Durum
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="fas fa-rocket me-2"></i>
                                Hızlı Erişim
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <a href="products.php" class="btn btn-primary w-100">
                                        <i class="fas fa-boxes me-2"></i>
                                        Ürün Yönetimi
                                    </a>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <a href="customers.php" class="btn btn-success w-100">
                                        <i class="fas fa-users me-2"></i>
                                        Cari Tanımı
                                    </a>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <a href="sales.php" class="btn btn-warning w-100">
                                        <i class="fas fa-shopping-cart me-2"></i>
                                        Ürün Satış
                                    </a>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <a href="reports.php" class="btn btn-info w-100">
                                        <i class="fas fa-chart-bar me-2"></i>
                                        Cari Takip
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="fas fa-history me-2"></i>
                                Son Satışlar
                            </h5>
                        </div>
                        <div class="card-body">
                            <?php if (empty($son_satislar)): ?>
                                <div class="text-center py-4">
                                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">Henüz satış kaydı bulunmuyor.</p>
                                    <a href="sales.php" class="btn btn-primary">
                                        <i class="fas fa-plus me-2"></i>
                                        İlk Satışı Yap
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Satış ID</th>
                                                <th>Tarih</th>
                                                <th>Cari</th>
                                                <th>Tutar</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($son_satislar as $satis): ?>
                                                <tr>
                                                    <td>#<?php echo $satis['satis_id']; ?></td>
                                                    <td><?php echo date('d.m.Y H:i', strtotime($satis['satis_tarihi'])); ?></td>
                                                    <td><?php echo Security::escapeOutput($satis['firma_adi']); ?></td>
                                                    <td>₺<?php echo number_format($satis['toplam_tutar'], 2); ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

