<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Erişim Reddedildi - Depo Stok Takip Sistemi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .error-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            padding: 3rem;
            text-align: center;
        }
        .error-icon {
            font-size: 5rem;
            color: #dc3545;
            margin-bottom: 1rem;
        }
        .error-title {
            color: #333;
            font-weight: 600;
            margin-bottom: 1rem;
        }
        .error-message {
            color: #666;
            margin-bottom: 2rem;
        }
        .btn-back {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 25px;
            color: white;
            text-decoration: none;
            transition: transform 0.2s;
        }
        .btn-back:hover {
            transform: translateY(-2px);
            color: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="error-container">
                    <div class="error-icon">
                        <i class="fas fa-ban"></i>
                    </div>
                    <h1 class="error-title">Erişim Reddedildi</h1>
                    <p class="error-message">
                        Bu sayfaya erişim yetkiniz bulunmamaktadır.<br>
                        Lütfen sistem yöneticisi ile iletişime geçin.
                    </p>
                    <div class="mt-4">
                        <a href="dashboard.php" class="btn-back">
                            <i class="fas fa-arrow-left me-2"></i>
                            Ana Sayfaya Dön
                        </a>
                    </div>
                    <div class="mt-3">
                        <small class="text-muted">
                            Kullanıcı: <?php echo htmlspecialchars($_SESSION['username'] ?? 'Bilinmiyor'); ?><br>
                            Rol: <?php 
                                require_once '../includes/authorization.php';
                                $role_info = Authorization::getUserRoleInfo();
                                echo htmlspecialchars($role_info['rol_adi'] ?? 'Bilinmiyor');
                            ?>
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>

