<?php

$user_info = Authorization::getNavbarUserInfo();
?>

<div class="sidebar" id="sidebar">
    <div class="sidebar-header p-3">
        <h5 class="text-white mb-0">Depo Stok Takip</h5>
        <small class="text-light"><?= htmlspecialchars($user_info['role_name']) ?></small>
    </div>
    
    <ul class="nav flex-column p-3">
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : '' ?>" href="dashboard.php">
                <i class="fas fa-tachometer-alt me-2"></i>
                Dashboard
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'products.php' ? 'active' : '' ?>" href="products.php">
                <i class="fas fa-box me-2"></i>
                Ürün Yönetimi
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'customers.php' ? 'active' : '' ?>" href="customers.php">
                <i class="fas fa-users me-2"></i>
                Cari Tanımı
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'sales.php' ? 'active' : '' ?>" href="sales.php">
                <i class="fas fa-shopping-cart me-2"></i>
                Ürün Satış
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'stock_movements.php' ? 'active' : '' ?>" href="stock_movements.php">
                <i class="fas fa-exchange-alt me-2"></i>
                Stok Hareketleri
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'reports.php' ? 'active' : '' ?>" href="reports.php">
                <i class="fas fa-chart-bar me-2"></i>
                Raporlar
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'advanced_reports.php' ? 'active' : '' ?>" href="advanced_reports.php">
                <i class="fas fa-chart-line me-2"></i>
                Gelişmiş Raporlama
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'performance_monitor.php' ? 'active' : '' ?>" href="performance_monitor.php">
                <i class="fas fa-tachometer-alt me-2"></i>
                Performans İzleme
            </a>
        </li>

        
        <?php if (Authorization::hasRole('admin')): ?>
        <li class="nav-item mt-3">
            <h6 class="text-muted">Admin Paneli</h6>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'database_optimization.php' ? 'active' : '' ?>" href="database_optimization.php">
                <i class="fas fa-database me-2"></i>
                DB Optimizasyonu
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'error_management.php' ? 'active' : '' ?>" href="error_management.php">
                <i class="fas fa-bug me-2"></i>
                Hata Yönetimi
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'security_tests.php' ? 'active' : '' ?>" href="security_tests.php">
                <i class="fas fa-shield-alt me-2"></i>
                Güvenlik Testleri
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'user_management.php' ? 'active' : '' ?>" href="user_management.php">
                <i class="fas fa-users-cog me-2"></i>
                Kullanıcı Yönetimi
            </a>
        </li>
        <?php endif; ?>
        
        <li class="nav-item mt-4">
            <a class="nav-link text-danger" href="logout.php">
                <i class="fas fa-sign-out-alt me-2"></i>
                Çıkış Yap
            </a>
        </li>
    </ul>
</div>

<style>
.sidebar {
    position: fixed;
    top: 0;
    left: 0;
    width: 250px;
    height: 100vh;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    transition: all 0.3s ease;
    z-index: 1000;
    overflow-y: auto;
}

@media (max-width: 767px) {
    .sidebar {
        left: -250px;
        padding-top: 60px;
    }
}

.sidebar.active {
    left: 0;
}

.sidebar .nav-link {
    color: rgba(255, 255, 255, 0.8);
    padding: 12px 20px;
    border-radius: 8px;
    margin: 2px 0;
    transition: all 0.3s ease;
}

.sidebar .nav-link:hover,
.sidebar .nav-link.active {
    color: white;
    background: rgba(255, 255, 255, 0.1);
    transform: translateX(5px);
}

.sidebar .nav-link i {
    width: 20px;
}

.sidebar-header {
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

@media (min-width: 768px) {
    .sidebar {
        left: 0;
    }
    
    .main-content {
        margin-left: 250px;
    }
}

@media (max-width: 767px) {
    .sidebar.active {
        left: 0;
    }
    
    .main-content {
        margin-left: 0;
    }
}
</style>