<?php

$user_info = Authorization::getNavbarUserInfo();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Depo Stok Takip Sistemi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>

<div class="mobile-toggle">
    <button class="btn btn-primary" id="sidebarToggle">
        <i class="fas fa-bars"></i>
    </button>
</div>

<style>
.mobile-toggle {
    position: fixed;
    top: 10px;
    left: 10px;
    z-index: 1002;
}

.main-content {
    padding: 20px;
    transition: margin-left 0.3s ease;
}

@media (max-width: 767px) {
    .main-content {
        margin-top: 10px;
        padding: 60px 20px 20px 20px;
    }
}

@media (min-width: 768px) {
    .mobile-toggle {
        display: none;
    }
    
    .main-content {
        margin-top: 20px;
        margin-left: 250px;
    }
}
</style>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const sidebarToggleMobile = document.getElementById('sidebarToggle');
    const sidebar = document.getElementById('sidebar');
    
    if (sidebarToggleMobile && sidebar) {
        sidebarToggleMobile.addEventListener('click', function() {
            sidebar.classList.toggle('active');
        });
    }
    
    document.addEventListener('click', function(e) {
        if (window.innerWidth <= 767 && 
            sidebar && sidebar.classList.contains('active') &&
            !sidebar.contains(e.target) && 
            !sidebarToggleMobile.contains(e.target)) {
            sidebar.classList.remove('active');
        }
    });
});
</script>