<?php

require_once __DIR__ . '/../config/database.php';
require_once 'security.php';

class Authorization {
    
    public static function requirePageAccess($page_name, $permission_type = 'okuma') {
        if (!Security::hasPageAccess($page_name, $permission_type)) {
            self::accessDenied();
        }
    }
    
    public static function requireAdmin() {
        if (!Security::isAdmin()) {
            self::accessDenied();
        }
    }
    
    public static function requireManager() {
        if (!Security::isManager()) {
            self::accessDenied();
        }
    }
    
    public static function requireRole($role_name) {
        if (!self::hasRole($role_name)) {
            self::accessDenied();
        }
    }
    
    private static function accessDenied() {
        http_response_code(403);
        include 'pages/access_denied.php';
        exit();
    }
    
    public static function getUserRoleInfo() {
        global $database;
        
        $user_role = Security::getUserRole();
        if (!$user_role) {
            return null;
        }
        
        try {
            $sql = "SELECT rol_adi, aciklama FROM roller WHERE rol_id = ?";
            return $database->fetch($sql, [$user_role]);
        } catch (Exception $e) {
            error_log("Rol bilgisi alınırken hata: " . $e->getMessage());
            return null;
        }
    }
    
    public static function getUserPagePermissions($page_name) {
        global $database;
        
        $user_role = Security::getUserRole();
        if (!$user_role) {
            return ['okuma' => 0, 'yazma' => 0, 'silme' => 0];
        }
        
        try {
            $sql = "SELECT okuma, yazma, silme FROM sayfa_yetkileri WHERE rol_id = ? AND sayfa_adi = ?";
            $result = $database->fetch($sql, [$user_role, $page_name]);
            
            return $result ?: ['okuma' => 0, 'yazma' => 0, 'silme' => 0];
        } catch (Exception $e) {
            error_log("Sayfa yetkileri alınırken hata: " . $e->getMessage());
            return ['okuma' => 0, 'yazma' => 0, 'silme' => 0];
        }
    }
    
    public static function hasRole($role_name) {
        $role_info = self::getUserRoleInfo();
        if (!$role_info) {
            return false;
        }
        
        return strtolower($role_info['rol_adi']) === strtolower($role_name);
    }
    
    public static function hasPagePermission($user_id, $page_name, $permission_type = 'okuma') {
        global $database;
        
        try {
            $sql = "SELECT rol_id FROM kullanicilar WHERE kullanici_id = ?";
            $user = $database->fetch($sql, [$user_id]);
            
            if (!$user) {
                return false;
            }
            
            $sql = "SELECT {$permission_type} FROM sayfa_yetkileri WHERE rol_id = ? AND sayfa_adi = ?";
            $permission = $database->fetch($sql, [$user['rol_id'], $page_name]);
            
            return $permission && $permission[$permission_type] == 1;
        } catch (Exception $e) {
            error_log("Sayfa yetkisi kontrolünde hata: " . $e->getMessage());
            return false;
        }
    }
    
    public static function getNavbarUserInfo() {
        $role_info = self::getUserRoleInfo();
        
        return [
            'username' => $_SESSION['username'] ?? '',
            'role_name' => $role_info['rol_adi'] ?? 'Bilinmiyor',
            'role_description' => $role_info['aciklama'] ?? '',
            'is_admin' => Security::isAdmin(),
            'is_manager' => Security::isManager()
        ];
    }
}
?>

