-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Anamakine: 127.0.0.1
-- Üretim Zamanı: 12 Eki 2025, 14:51:26
-- Sunucu sürümü: 10.4.32-MariaDB
-- PHP Sürümü: 8.0.30

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Veritabanı: `depo_stok_takip`
--

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `cariler`
--

CREATE TABLE `cariler` (
  `cari_id` int(11) NOT NULL,
  `firma_adi` varchar(255) NOT NULL,
  `cari_adi` varchar(255) DEFAULT NULL,
  `yetkili_adi` varchar(100) DEFAULT NULL,
  `telefon` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `cari_tipi` enum('musteri','tedarikci') NOT NULL DEFAULT 'musteri',
  `adres` text DEFAULT NULL,
  `vergi_no` varchar(50) DEFAULT NULL,
  `cari_bakiye` decimal(20,2) DEFAULT 0.00,
  `bakiye` decimal(20,2) DEFAULT 0.00,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `cariler`
--

INSERT INTO `cariler` (`cari_id`, `firma_adi`, `cari_adi`, `yetkili_adi`, `telefon`, `email`, `cari_tipi`, `adres`, `vergi_no`, `cari_bakiye`, `bakiye`, `olusturulma_tarihi`) VALUES
(1, 'ABC Ticaret Ltd.', 'ABC Ticaret Ltd.', 'Ahmet YÄ±lmaz', '0532 123 45 67', 'ahmet@abcticaret.com', 'musteri', 'Ä°stanbul, KadÄ±kÃ¶y', '124213', 0.00, 0.00, '2025-10-11 15:37:25'),
(2, 'XYZ Tedarik A.Åž.', 'XYZ Tedarik A.Åž.', 'Mehmet Demir', '0533 987 65 43', 'mehmet@xyztedarik.com', 'tedarikci', 'Ankara, Ã‡ankaya', NULL, 0.00, 0.00, '2025-10-11 15:37:25'),
(3, 'DEF Market', 'DEF Market', 'AyÅŸe Kaya', '0534 555 66 77', 'ayse@defmarket.com', 'musteri', 'Ä°zmir, Konak', NULL, 0.00, 0.00, '2025-10-11 15:37:25'),
(6, '12341234', 'afasfa', NULL, '5421212312', 'dfgdasg@gmail.com', 'tedarikci', 'afasdfads', '123421312', 0.00, 0.00, '2025-10-12 11:01:08');

-- --------------------------------------------------------

--
-- Görünüm yapısı durumu `cari_bakiye_ozeti`
-- (Asıl görünüm için aşağıya bakın)
--
CREATE TABLE `cari_bakiye_ozeti` (
`cari_id` int(11)
,`firma_adi` varchar(255)
,`cari_tipi` enum('musteri','tedarikci')
,`toplam_borc` decimal(42,2)
,`toplam_alacak` decimal(42,2)
,`bakiye` decimal(42,2)
);

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `cari_hareketler`
--

CREATE TABLE `cari_hareketler` (
  `hareket_id` int(11) NOT NULL,
  `cari_id` int(11) NOT NULL,
  `hareket_tipi` enum('borc','alacak') NOT NULL,
  `tutar` decimal(20,2) NOT NULL,
  `aciklama` varchar(255) DEFAULT NULL,
  `satis_id` int(11) DEFAULT NULL,
  `tarih` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `cari_hareketler`
--

INSERT INTO `cari_hareketler` (`hareket_id`, `cari_id`, `hareket_tipi`, `tutar`, `aciklama`, `satis_id`, `tarih`) VALUES
(1, 3, 'borc', 675.00, 'SatÄ±ÅŸ No: 1', 1, '2025-10-11 16:14:08'),
(2, 3, 'alacak', 675.00, 'Manuel ödeme', NULL, '2025-10-11 16:17:36'),
(3, 3, 'borc', 10.00, 'Satýþ No: 2 - Kalan Borç (Düzeltme)', 2, '2025-10-11 16:18:16'),
(4, 3, 'alacak', 5.00, 'Manuel ödeme', NULL, '2025-10-11 16:20:43'),
(5, 3, 'alacak', 5.00, 'Manuel ödeme', NULL, '2025-10-11 16:26:17'),
(6, 1, 'borc', 180.00, 'SatÄ±ÅŸ No: 3', 3, '2025-10-11 16:26:55'),
(7, 1, 'borc', 30.00, 'Satış No: 3 - Kalan Borç', 3, '2025-10-11 16:26:56'),
(8, 1, 'alacak', 150.00, 'Satış No: 3 - Ödeme', 3, '2025-10-11 16:26:56'),
(9, 1, 'alacak', 210.00, 'Manuel ödeme', NULL, '2025-10-11 16:28:22'),
(10, 1, 'borc', 210.00, 'SatÄ±ÅŸ No: 4', 4, '2025-10-11 16:28:44'),
(11, 1, 'borc', 30.00, 'Satış No: 4 - Kalan Borç', 4, '2025-10-11 16:28:44'),
(12, 1, 'alacak', 180.00, 'Satış No: 4 - Ödeme', 4, '2025-10-11 16:28:44'),
(13, 3, 'alacak', 200.00, 'Satýþ No: 2 - Ödeme (Düzeltme)', 2, '2025-10-11 16:31:12'),
(14, 1, 'alacak', 240.00, 'Manuel ödeme', NULL, '2025-10-11 16:34:27'),
(15, 3, 'alacak', 10.00, 'Manuel ödeme', NULL, '2025-10-11 16:34:31'),
(16, 1, 'borc', 180.00, 'SatÄ±ÅŸ No: 5', 5, '2025-10-11 16:34:53'),
(17, 1, 'borc', 80.00, 'Satış No: 5 - Kalan Borç', 5, '2025-10-11 16:34:53'),
(18, 1, 'alacak', 100.00, 'Satış No: 5 - Ödeme', 5, '2025-10-11 16:34:53'),
(19, 1, 'alacak', 260.00, 'Manuel ödeme', NULL, '2025-10-11 16:38:37'),
(20, 1, 'borc', 104.00, 'Satış No: 6', 6, '2025-10-11 16:38:50'),
(21, 1, 'alacak', 90.00, 'Satış No: 6 - Ödeme', 6, '2025-10-11 16:38:50'),
(22, 1, 'borc', 14.00, 'Satış No: 6 - Kalan Borç', 6, '2025-10-11 16:38:50'),
(23, 1, 'alacak', 90.00, 'Satış No: 6 - Ödeme', 6, '2025-10-11 16:38:50'),
(24, 1, 'alacak', 28.00, 'Manuel ödeme', NULL, '2025-10-11 16:39:02'),
(25, 1, 'borc', 345.00, 'Satış No: 7', 7, '2025-10-11 16:39:16'),
(26, 1, 'alacak', 300.00, 'Satış No: 7 - Ödeme', 7, '2025-10-11 16:39:16'),
(27, 1, 'borc', 45.00, 'Satış No: 7 - Kalan Borç', 7, '2025-10-11 16:39:16'),
(28, 1, 'alacak', 300.00, 'Satış No: 7 - Ödeme', 7, '2025-10-11 16:39:16'),
(29, 1, 'alacak', 90.00, 'Manuel ödeme', NULL, '2025-10-11 16:42:51'),
(30, 1, 'borc', 16.00, 'Satış No: 8', 8, '2025-10-11 16:43:06'),
(31, 1, 'alacak', 12.00, 'Satış No: 8 - Ödeme', 8, '2025-10-11 16:43:06'),
(32, 1, 'borc', 4.00, 'Satış No: 8 - Kalan Borç', 8, '2025-10-11 16:43:06'),
(33, 1, 'alacak', 12.00, 'Satış No: 8 - Ödeme', 8, '2025-10-11 16:43:06'),
(34, 1, 'alacak', 2.00, 'Manuel ödeme', NULL, '2025-10-11 16:43:20'),
(35, 1, 'alacak', 2.00, 'Manuel ödeme', NULL, '2025-10-11 16:43:23'),
(36, 1, 'borc', 225.00, 'Satış No: 9', 9, '2025-10-11 16:43:36'),
(37, 1, 'alacak', 200.00, 'Satış No: 9 - Ödeme', 9, '2025-10-11 16:43:36'),
(38, 1, 'borc', 25.00, 'Satış No: 9 - Kalan Borç', 9, '2025-10-11 16:43:36'),
(39, 1, 'alacak', 200.00, 'Satış No: 9 - Ödeme', 9, '2025-10-11 16:43:36'),
(40, 1, 'alacak', 25.00, 'odeme aldık', NULL, '2025-10-11 16:43:56'),
(41, 1, 'borc', 675.00, 'Satış No: 10', 10, '2025-10-12 11:01:36'),
(42, 1, 'alacak', 121.00, 'Satış No: 10 - Ödeme', 10, '2025-10-12 11:01:36'),
(43, 1, 'borc', 675.00, 'Satış No: 10', 10, '2025-10-12 11:01:36'),
(44, 1, 'alacak', 121.00, 'Satış No: 10 - Ödeme', 10, '2025-10-12 11:01:36'),
(45, 3, 'borc', 736.00, 'Satış No: 11', 11, '2025-10-12 11:01:59'),
(46, 3, 'alacak', 121.00, 'Satış No: 11 - Ödeme', 11, '2025-10-12 11:01:59'),
(47, 3, 'borc', 736.00, 'Satış No: 11', 11, '2025-10-12 11:01:59'),
(48, 3, 'alacak', 121.00, 'Satış No: 11 - Ödeme', 11, '2025-10-12 11:01:59'),
(49, 1, 'borc', 6048.00, 'Satış No: 12', 12, '2025-10-12 11:05:52'),
(50, 1, 'alacak', 6048.00, 'Satış No: 12 - Ödeme', 12, '2025-10-12 11:05:52'),
(51, 1, 'borc', 6048.00, 'Satış No: 12', 12, '2025-10-12 11:05:52'),
(52, 1, 'alacak', 6048.00, 'Satış No: 12 - Ödeme', 12, '2025-10-12 11:05:52'),
(53, 1, 'borc', 300.00, 'Satış No: 13', 13, '2025-10-12 11:06:13'),
(54, 1, 'borc', 300.00, 'Satış No: 13', 13, '2025-10-12 11:06:13'),
(55, 1, 'borc', 450.00, 'Satış No: 14', 14, '2025-10-12 11:22:22'),
(56, 1, 'alacak', 121.00, 'Satış No: 14 - Ödeme', 14, '2025-10-12 11:22:22'),
(57, 1, 'borc', 450.00, 'Satış No: 14', 14, '2025-10-12 11:22:22'),
(58, 1, 'alacak', 121.00, 'Satış No: 14 - Ödeme', 14, '2025-10-12 11:22:22'),
(59, 3, 'borc', 96.00, 'Satış No: 15', 15, '2025-10-12 12:10:00'),
(60, 3, 'alacak', 20.00, 'Satış No: 15 - Ödeme', 15, '2025-10-12 12:10:00'),
(61, 3, 'borc', 96.00, 'Satış No: 15', 15, '2025-10-12 12:10:00'),
(62, 3, 'alacak', 20.00, 'Satış No: 15 - Ödeme', 15, '2025-10-12 12:10:00'),
(63, 3, 'borc', 75.00, 'Satış No: 16', 16, '2025-10-12 12:10:23'),
(64, 3, 'alacak', 1.00, 'Satış No: 16 - Ödeme', 16, '2025-10-12 12:10:23'),
(65, 3, 'borc', 75.00, 'Satış No: 16', 16, '2025-10-12 12:10:23'),
(66, 3, 'alacak', 1.00, 'Satış No: 16 - Ödeme', 16, '2025-10-12 12:10:23'),
(67, 1, 'alacak', 63.00, 'Manuel tahsilat', NULL, '2025-10-12 12:17:35'),
(68, 3, 'alacak', 20.00, 'Manuel tahsilat', NULL, '2025-10-12 12:17:41'),
(69, 1, 'alacak', 15.00, 'Manuel tahsilat', NULL, '2025-10-12 12:17:49'),
(70, 1, 'alacak', 85.00, 'Manuel tahsilat', NULL, '2025-10-12 12:17:59'),
(71, 1, 'alacak', 1200.00, 'Manuel tahsilat', NULL, '2025-10-12 12:18:03'),
(72, 3, 'alacak', 300.00, 'Manuel tahsilat', NULL, '2025-10-12 12:18:09'),
(73, 3, 'alacak', 300.00, 'Manuel tahsilat', NULL, '2025-10-12 12:18:18'),
(74, 3, 'alacak', 300.00, 'Manuel tahsilat', NULL, '2025-10-12 12:18:27'),
(75, 3, 'alacak', 300.00, 'Manuel tahsilat', NULL, '2025-10-12 12:18:58'),
(76, 3, 'alacak', 100.00, 'Manuel tahsilat', NULL, '2025-10-12 12:19:06'),
(77, 6, 'alacak', 144.00, 'Stok alımı - Transfer ID:  -  - Ref: 213213421', NULL, '2025-10-12 12:20:10'),
(78, 6, 'borc', 121.00, 'Stok alımı ödemesi - Transfer ID:  -  - Ref: 213213421', NULL, '2025-10-12 12:20:10'),
(79, 1, 'borc', 384.00, 'Satış No: 17', 17, '2025-10-12 12:24:04'),
(80, 1, 'alacak', 384.00, 'Satış No: 17 - Ödeme', 17, '2025-10-12 12:24:04'),
(81, 1, 'borc', 384.00, 'Satış No: 17', 17, '2025-10-12 12:24:04'),
(82, 1, 'alacak', 384.00, 'Satış No: 17 - Ödeme', 17, '2025-10-12 12:24:05'),
(83, 1, 'borc', 672.00, 'Satış No: 18', 18, '2025-10-12 12:24:27'),
(84, 1, 'alacak', 1.00, 'Satış No: 18 - Ödeme', 18, '2025-10-12 12:24:27'),
(85, 1, 'borc', 672.00, 'Satış No: 18', 18, '2025-10-12 12:24:27'),
(86, 1, 'alacak', 1.00, 'Satış No: 18 - Ödeme', 18, '2025-10-12 12:24:27'),
(87, 1, 'alacak', 200.00, 'Manuel tahsilat', NULL, '2025-10-12 12:24:39'),
(88, 1, 'alacak', 121.00, 'Manuel tahsilat', NULL, '2025-10-12 12:24:49'),
(89, 1, 'alacak', 1021.00, 'Manuel tahsilat', NULL, '2025-10-12 12:24:52'),
(90, 6, 'borc', 2532.00, 'Stok alımı - Transfer ID:  -  - Ref: 121', NULL, '2025-10-12 12:25:46'),
(91, 6, 'alacak', 12.00, 'Stok alımı ödemesi - Transfer ID:  -  - Ref: 121', NULL, '2025-10-12 12:25:46'),
(92, 6, 'borc', 12.00, 'Manuel ödeme', NULL, '2025-10-12 12:25:58'),
(93, 6, 'borc', 9.00, 'Manuel ödeme', NULL, '2025-10-12 12:26:04'),
(94, 6, 'borc', 9.00, 'Manuel ödeme', NULL, '2025-10-12 12:26:09'),
(95, 6, 'borc', 1000.00, 'Manuel ödeme', NULL, '2025-10-12 12:26:19'),
(96, 6, 'alacak', 527.00, 'Manuel ödeme', NULL, '2025-10-12 12:29:37'),
(97, 6, 'alacak', 1000.00, 'Manuel ödeme', NULL, '2025-10-12 12:29:45'),
(98, 6, 'alacak', 2000.00, 'Manuel ödeme', NULL, '2025-10-12 12:29:49');

-- --------------------------------------------------------

--
-- Görünüm yapısı durumu `hizli_cari_bakiye`
-- (Asıl görünüm için aşağıya bakın)
--
CREATE TABLE `hizli_cari_bakiye` (
`cari_id` int(11)
,`firma_adi` varchar(255)
,`cari_tipi` enum('musteri','tedarikci')
,`cari_bakiye` decimal(20,2)
,`durum` varchar(8)
);

-- --------------------------------------------------------

--
-- Görünüm yapısı durumu `hizli_stok_durumu`
-- (Asıl görünüm için aşağıya bakın)
--
CREATE TABLE `hizli_stok_durumu` (
`urun_id` int(11)
,`urun_adi` varchar(255)
,`stok_miktari` int(11)
,`alis_fiyati` decimal(20,2)
,`satis_fiyati` decimal(20,2)
,`kar_marji` decimal(21,2)
,`stok_durumu` varchar(6)
,`toplam_deger` decimal(30,2)
);

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `kullanicilar`
--

CREATE TABLE `kullanicilar` (
  `kullanici_id` int(11) NOT NULL,
  `kullanici_adi` varchar(50) NOT NULL,
  `sifre_hash` varchar(255) NOT NULL,
  `ad_soyad` varchar(100) NOT NULL,
  `rol_id` int(11) DEFAULT 1,
  `aktif` tinyint(1) DEFAULT 1,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `kullanicilar`
--

INSERT INTO `kullanicilar` (`kullanici_id`, `kullanici_adi`, `sifre_hash`, `ad_soyad`, `rol_id`, `aktif`, `olusturulma_tarihi`) VALUES
(1, 'admin', '$argon2id$v=19$m=65536,t=4,p=3$OGltREpndGJtN3o3Q2F0NQ$VK8FhPwoGx2zmhJzTHiGrokDjtlNvNIG+fzQJgOohRI', 'Sistem Yöneticisi', 1, 1, '2025-10-11 15:15:02'),
(3, 'manager_demo', '$argon2id$v=19$m=65536,t=4,p=3$eVRJVG5BdHhWZHJ4elh2Zg$BxqCFFCpOEL59pbfnlUVviboxI5Aey1eqgxdYYdx61s', 'Manager Demo', 2, 1, '2025-10-11 21:26:11'),
(4, 'employee_demo', '$argon2id$v=19$m=65536,t=4,p=3$ZFVWMTQ3VTNpWE42TU5DSw$XWVlERS3f3d4jGv3cUaocmTiKCDARlHSFbB3WyAMVBw', 'Employee Demo', 4, 1, '2025-10-11 21:26:11'),
(5, 'viewer_demo', '$argon2id$v=19$m=65536,t=4,p=3$M0Q2eks2QkJGYloxRkdRYQ$y0/b6+zTSzGGbnFnO+AlmvFH7tzB3Z9eS3bR2KmdVJI', 'Viewer Demo', 4, 1, '2025-10-11 21:26:11');

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `performance_log`
--

CREATE TABLE `performance_log` (
  `log_id` int(11) NOT NULL,
  `operation_type` varchar(50) NOT NULL,
  `table_name` varchar(100) DEFAULT NULL,
  `execution_time` decimal(10,4) NOT NULL,
  `memory_usage` decimal(20,2) DEFAULT NULL,
  `query_hash` varchar(32) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Tablo döküm verisi `performance_log`
--

INSERT INTO `performance_log` (`log_id`, `operation_type`, `table_name`, `execution_time`, `memory_usage`, `query_hash`, `details`, `created_at`) VALUES
(1, 'performance_monitor_view', 'performance_monitor', 0.0294, 0.02, NULL, NULL, '2025-10-11 21:02:19'),
(2, 'performance_monitor_view', 'performance_monitor', 0.0047, 0.02, NULL, NULL, '2025-10-11 21:02:42'),
(3, 'performance_monitor_view', 'performance_monitor', 0.0039, 0.02, NULL, NULL, '2025-10-11 21:05:29'),
(4, 'performance_monitor_view', 'performance_monitor', 0.0057, 0.02, NULL, NULL, '2025-10-11 21:15:58'),
(5, 'performance_monitor_view', 'performance_monitor', 0.0050, 0.02, NULL, NULL, '2025-10-11 21:17:05'),
(6, 'performance_monitor_view', 'performance_monitor', 0.0036, 0.02, NULL, NULL, '2025-10-11 21:41:27'),
(7, 'performance_monitor_view', 'performance_monitor', 0.0045, 0.02, NULL, NULL, '2025-10-11 21:56:17'),
(8, 'performance_monitor_view', 'performance_monitor', 0.0054, 0.02, NULL, NULL, '2025-10-11 21:56:47'),
(9, 'performance_monitor_view', 'performance_monitor', 0.0067, 0.02, NULL, NULL, '2025-10-11 21:57:17'),
(10, 'performance_monitor_view', 'performance_monitor', 0.0072, 0.02, NULL, NULL, '2025-10-11 21:57:48'),
(11, 'performance_monitor_view', 'performance_monitor', 0.0070, 0.02, NULL, NULL, '2025-10-11 21:58:19'),
(12, 'performance_monitor_view', 'performance_monitor', 0.0053, 0.02, NULL, NULL, '2025-10-11 21:58:50'),
(13, 'performance_monitor_view', 'performance_monitor', 0.0046, 0.02, NULL, NULL, '2025-10-11 21:59:21'),
(14, 'performance_monitor_view', 'performance_monitor', 0.0040, 0.02, NULL, NULL, '2025-10-11 21:59:52'),
(15, 'performance_monitor_view', 'performance_monitor', 0.0046, 0.02, NULL, NULL, '2025-10-11 22:00:23'),
(16, 'performance_monitor_view', 'performance_monitor', 0.0072, 0.02, NULL, NULL, '2025-10-11 22:00:54'),
(17, 'performance_monitor_view', 'performance_monitor', 0.0065, 0.02, NULL, NULL, '2025-10-11 22:01:25'),
(18, 'performance_monitor_view', 'performance_monitor', 0.0043, 0.02, NULL, NULL, '2025-10-11 22:01:56'),
(19, 'performance_monitor_view', 'performance_monitor', 0.0051, 0.02, NULL, NULL, '2025-10-11 22:02:27'),
(20, 'performance_monitor_view', 'performance_monitor', 0.0060, 0.02, NULL, NULL, '2025-10-11 22:02:58'),
(21, 'performance_monitor_view', 'performance_monitor', 0.0046, 0.02, NULL, NULL, '2025-10-11 22:03:29'),
(22, 'performance_monitor_view', 'performance_monitor', 0.0050, 0.02, NULL, NULL, '2025-10-11 22:04:00'),
(23, 'performance_monitor_view', 'performance_monitor', 0.0059, 0.02, NULL, NULL, '2025-10-11 22:04:31'),
(24, 'performance_monitor_view', 'performance_monitor', 0.0052, 0.02, NULL, NULL, '2025-10-11 22:05:02'),
(25, 'performance_monitor_view', 'performance_monitor', 0.0037, 0.02, NULL, NULL, '2025-10-11 22:05:33'),
(26, 'performance_monitor_view', 'performance_monitor', 0.0045, 0.02, NULL, NULL, '2025-10-11 22:06:00'),
(27, 'performance_monitor_view', 'performance_monitor', 0.0047, 0.02, NULL, NULL, '2025-10-11 22:08:58'),
(28, 'performance_monitor_view', 'performance_monitor', 0.0045, 0.02, NULL, NULL, '2025-10-11 22:18:28'),
(29, 'performance_monitor_view', 'performance_monitor', 0.0054, 0.02, NULL, NULL, '2025-10-12 11:29:30'),
(30, 'performance_monitor_view', 'performance_monitor', 0.0048, 0.02, NULL, NULL, '2025-10-12 11:30:18'),
(31, 'performance_monitor_view', 'performance_monitor', 0.0047, 0.02, NULL, NULL, '2025-10-12 12:23:48'),
(32, 'performance_monitor_view', 'performance_monitor', 0.0051, 0.02, NULL, NULL, '2025-10-12 12:32:43');

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `rapor_gecmisi`
--

CREATE TABLE `rapor_gecmisi` (
  `gecmis_id` int(11) NOT NULL,
  `rapor_id` int(11) DEFAULT NULL,
  `kullanici_id` int(11) DEFAULT NULL,
  `rapor_parametreleri` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`rapor_parametreleri`)),
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `dosya_yolu` varchar(500) DEFAULT NULL,
  `rapor_durumu` enum('olusturuluyor','tamamlandi','hata') DEFAULT 'olusturuluyor',
  `hata_mesaji` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `rapor_sablonlari`
--

CREATE TABLE `rapor_sablonlari` (
  `rapor_id` int(11) NOT NULL,
  `rapor_adi` varchar(255) NOT NULL,
  `rapor_tipi` enum('stok','cari','satis','genel','finansal') NOT NULL,
  `rapor_sorgusu` text NOT NULL,
  `rapor_parametreleri` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`rapor_parametreleri`)),
  `olusturan_kullanici_id` int(11) DEFAULT NULL,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `guncelleme_tarihi` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `aktif` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `rapor_sablonlari`
--

INSERT INTO `rapor_sablonlari` (`rapor_id`, `rapor_adi`, `rapor_tipi`, `rapor_sorgusu`, `rapor_parametreleri`, `olusturan_kullanici_id`, `olusturulma_tarihi`, `guncelleme_tarihi`, `aktif`) VALUES
(1, 'Stok Durum Raporu', 'stok', 'SELECT u.urun_adi, u.stok_miktari, u.alis_fiyati, u.satis_fiyati, \r\n        (u.stok_miktari * u.alis_fiyati) as toplam_deger,\r\n        CASE \r\n            WHEN u.stok_miktari <= 10 THEN \"Kritik\"\r\n            WHEN u.stok_miktari <= 50 THEN \"Düşük\"\r\n            ELSE \"Normal\"\r\n        END as stok_durumu\r\n FROM urunler u \r\n WHERE u.stok_miktari >= ? AND u.stok_miktari <= ?\r\n ORDER BY u.stok_miktari ASC', '{\"min_stok\": 0, \"max_stok\": 1000}', NULL, '2025-10-11 19:25:57', '2025-10-11 19:25:57', 1),
(2, 'Cari Hesap Raporu', 'cari', 'SELECT c.firma_adi, c.cari_tipi, \r\n        SUM(CASE WHEN ch.hareket_tipi = \"borc\" THEN ch.tutar ELSE 0 END) as toplam_borc,\r\n        SUM(CASE WHEN ch.hareket_tipi = \"alacak\" THEN ch.tutar ELSE 0 END) as toplam_alacak,\r\n        (SUM(CASE WHEN ch.hareket_tipi = \"borc\" THEN ch.tutar ELSE 0 END) - \r\n         SUM(CASE WHEN ch.hareket_tipi = \"alacak\" THEN ch.tutar ELSE 0 END)) as bakiye\r\n FROM cariler c \r\n LEFT JOIN cari_hareketler ch ON c.cari_id = ch.cari_id \r\n WHERE ch.tarih BETWEEN ? AND ?\r\n GROUP BY c.cari_id, c.firma_adi, c.cari_tipi\r\n ORDER BY bakiye DESC', '{\"baslangic_tarihi\": \"\", \"bitis_tarihi\": \"\"}', NULL, '2025-10-11 19:25:57', '2025-10-11 19:25:57', 1);

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `rapor_widgets`
--

CREATE TABLE `rapor_widgets` (
  `widget_id` int(11) NOT NULL,
  `widget_adi` varchar(255) NOT NULL,
  `widget_tipi` enum('grafik','tablo','kart','gauge') NOT NULL,
  `widget_sorgusu` text NOT NULL,
  `widget_ayarlari` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`widget_ayarlari`)),
  `dashboard_pozisyonu` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`dashboard_pozisyonu`)),
  `olusturan_kullanici_id` int(11) DEFAULT NULL,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `aktif` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `rapor_widgets`
--

INSERT INTO `rapor_widgets` (`widget_id`, `widget_adi`, `widget_tipi`, `widget_sorgusu`, `widget_ayarlari`, `dashboard_pozisyonu`, `olusturan_kullanici_id`, `olusturulma_tarihi`, `aktif`) VALUES
(1, 'Toplam Ürün Sayısı', 'kart', 'SELECT COUNT(*) as toplam FROM urunler WHERE stok_miktari > 0', '{\"icon\": \"fas fa-boxes\", \"color\": \"primary\", \"title\": \"Aktif Ürünler\"}', NULL, NULL, '2025-10-11 19:25:58', 1),
(2, 'Kritik Stok Uyarısı', 'kart', 'SELECT COUNT(*) as toplam FROM urunler WHERE stok_miktari <= 10', '{\"icon\": \"fas fa-exclamation-triangle\", \"color\": \"danger\", \"title\": \"Kritik Stok\"}', NULL, NULL, '2025-10-11 19:25:58', 1),
(3, 'Toplam Stok Değeri', 'kart', 'SELECT SUM(stok_miktari * alis_fiyati) as toplam FROM urunler', '{\"icon\": \"fas fa-dollar-sign\", \"color\": \"success\", \"title\": \"Toplam Stok Değeri\"}', NULL, NULL, '2025-10-11 19:25:58', 1);

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `roller`
--

CREATE TABLE `roller` (
  `rol_id` int(11) NOT NULL,
  `rol_adi` varchar(50) NOT NULL,
  `aciklama` varchar(255) DEFAULT NULL,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `roller`
--

INSERT INTO `roller` (`rol_id`, `rol_adi`, `aciklama`, `olusturulma_tarihi`) VALUES
(1, 'admin', 'Sistem yöneticisi - Tüm yetkilere sahip', '2025-10-11 19:25:57'),
(2, 'manager', 'Mağaza müdürü - Satış ve raporlama yetkisi', '2025-10-11 19:25:57'),
(3, 'employee', 'Çalışan - Sadece satış yetkisi', '2025-10-11 19:25:57'),
(4, 'viewer', 'Görüntüleyici - Sadece okuma yetkisi', '2025-10-11 19:25:57');

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `satislar`
--

CREATE TABLE `satislar` (
  `satis_id` int(11) NOT NULL,
  `satis_tarihi` datetime NOT NULL,
  `kullanici_id` int(11) NOT NULL,
  `cari_id` int(11) NOT NULL,
  `toplam_tutar` decimal(20,2) NOT NULL,
  `odenen_tutar` decimal(20,2) DEFAULT 0.00,
  `kalan_tutar` decimal(20,2) DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `satislar`
--

INSERT INTO `satislar` (`satis_id`, `satis_tarihi`, `kullanici_id`, `cari_id`, `toplam_tutar`, `odenen_tutar`, `kalan_tutar`) VALUES
(1, '2025-10-11 19:14:08', 1, 3, 675.00, 675.00, 0.00),
(2, '2025-10-11 19:18:16', 1, 3, 210.00, 210.00, 0.00),
(3, '2025-10-11 19:26:55', 1, 1, 180.00, 180.00, 0.00),
(4, '2025-10-11 19:28:44', 1, 1, 210.00, 210.00, 0.00),
(5, '2025-10-11 19:34:53', 1, 1, 180.00, 180.00, 0.00),
(6, '2025-10-11 19:38:50', 1, 1, 104.00, 104.00, 0.00),
(7, '2025-10-11 19:39:16', 1, 1, 345.00, 345.00, 0.00),
(8, '2025-10-11 19:43:06', 1, 1, 16.00, 16.00, 0.00),
(9, '2025-10-11 19:43:36', 1, 1, 225.00, 225.00, 0.00),
(10, '2025-10-12 14:01:36', 1, 1, 675.00, 675.00, 0.00),
(11, '2025-10-12 14:01:59', 1, 3, 736.00, 736.00, 0.00),
(12, '2025-10-12 14:05:52', 1, 1, 6048.00, 6048.00, 0.00),
(13, '2025-10-12 14:06:13', 1, 1, 300.00, 300.00, 0.00),
(14, '2025-10-12 14:22:22', 1, 1, 450.00, 450.00, 0.00),
(15, '2025-10-12 15:10:00', 1, 3, 96.00, 96.00, 0.00),
(16, '2025-10-12 15:10:23', 1, 3, 75.00, 75.00, 0.00),
(17, '2025-10-12 15:24:04', 1, 1, 384.00, 384.00, 0.00),
(18, '2025-10-12 15:24:27', 1, 1, 672.00, 672.00, 0.00);

--
-- Tetikleyiciler `satislar`
--
DELIMITER $$
CREATE TRIGGER `satis_silme_sonrasi_cari_hareket` AFTER DELETE ON `satislar` FOR EACH ROW BEGIN
    DELETE FROM cari_hareketler WHERE satis_id = OLD.satis_id;
    
    UPDATE cariler 
    SET cari_bakiye = cari_bakiye - OLD.toplam_tutar,
        bakiye = bakiye - OLD.toplam_tutar
    WHERE cari_id = OLD.cari_id;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `satis_sonrasi_cari_hareket` AFTER INSERT ON `satislar` FOR EACH ROW BEGIN
        -- NOT: Cari hareketler artık kod tarafından ekleniyor (BalanceManager)
        -- Bu trigger sadece eski sistemle uyumluluk için bakiye günceller
        
        -- Eğer kod tarafından hareket eklenmemişse (eski sistem), ekle
        -- Yeni sistemde bu blok çalışmayacak çünkü hareket zaten eklenmiş olacak
        
        DECLARE hareket_sayisi INT;
        
        -- Bu satış için kaç hareket var kontrol et
        SELECT COUNT(*) INTO hareket_sayisi 
        FROM cari_hareketler 
        WHERE satis_id = NEW.satis_id;
        
        -- Eğer hiç hareket yoksa (eski sistem), ekle
        IF hareket_sayisi = 0 THEN
            -- Borç kaydı (toplam tutar)
            INSERT INTO cari_hareketler (cari_id, hareket_tipi, tutar, aciklama, satis_id, tarih)
            VALUES (NEW.cari_id, 'borc', NEW.toplam_tutar, CONCAT('Satış No: ', NEW.satis_id), NEW.satis_id, NEW.satis_tarihi);
            
            -- Alacak kaydı (ödenen tutar, eğer varsa)
            IF NEW.odenen_tutar > 0 THEN
                INSERT INTO cari_hareketler (cari_id, hareket_tipi, tutar, aciklama, satis_id, tarih)
                VALUES (NEW.cari_id, 'alacak', NEW.odenen_tutar, CONCAT('Satış No: ', NEW.satis_id, ' - Ödeme'), NEW.satis_id, NEW.satis_tarihi);
            END IF;
            
            -- Bakiye güncelle
            UPDATE cariler 
            SET cari_bakiye = cari_bakiye + (NEW.toplam_tutar - NEW.odenen_tutar),
                bakiye = bakiye + (NEW.toplam_tutar - NEW.odenen_tutar)
            WHERE cari_id = NEW.cari_id;
        END IF;
    END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `satis_detay`
--

CREATE TABLE `satis_detay` (
  `satis_detay_id` int(11) NOT NULL,
  `satis_id` int(11) NOT NULL,
  `urun_id` int(11) NOT NULL,
  `adet` int(11) NOT NULL,
  `birim_fiyat` decimal(20,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `satis_detay`
--

INSERT INTO `satis_detay` (`satis_detay_id`, `satis_id`, `urun_id`, `adet`, `birim_fiyat`) VALUES
(1, 1, 2, 3, 225.00),
(2, 2, 1, 14, 15.00),
(3, 3, 1, 12, 15.00),
(4, 4, 1, 14, 15.00),
(5, 5, 1, 12, 15.00),
(6, 6, 3, 13, 8.00),
(7, 7, 1, 23, 15.00),
(8, 8, 3, 2, 8.00),
(9, 9, 2, 1, 225.00),
(10, 10, 2, 3, 225.00),
(11, 11, 4, 23, 32.00),
(12, 12, 4, 189, 32.00),
(13, 13, 1, 20, 15.00),
(14, 14, 2, 2, 225.00),
(15, 15, 4, 3, 32.00),
(16, 16, 1, 5, 15.00),
(17, 17, 4, 12, 32.00),
(18, 18, 4, 21, 32.00);

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `sayfa_yetkileri`
--

CREATE TABLE `sayfa_yetkileri` (
  `yetki_id` int(11) NOT NULL,
  `rol_id` int(11) NOT NULL,
  `sayfa_adi` varchar(50) NOT NULL,
  `okuma` tinyint(1) DEFAULT 1,
  `yazma` tinyint(1) DEFAULT 0,
  `silme` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `sayfa_yetkileri`
--

INSERT INTO `sayfa_yetkileri` (`yetki_id`, `rol_id`, `sayfa_adi`, `okuma`, `yazma`, `silme`) VALUES
(1, 1, 'dashboard', 1, 1, 1),
(2, 1, 'products', 1, 1, 1),
(3, 1, 'customers', 1, 1, 1),
(4, 1, 'sales', 1, 1, 1),
(5, 1, 'reports', 1, 1, 1),
(6, 1, 'stock_movements', 1, 1, 1),
(7, 1, 'advanced_reports', 1, 1, 1),
(8, 2, 'dashboard', 1, 1, 0),
(9, 2, 'products', 1, 1, 0),
(10, 2, 'customers', 1, 1, 0),
(11, 2, 'sales', 1, 1, 0),
(12, 2, 'reports', 1, 0, 0),
(13, 2, 'stock_movements', 1, 1, 0),
(14, 2, 'advanced_reports', 1, 1, 0),
(15, 3, 'dashboard', 1, 0, 0),
(16, 3, 'products', 1, 0, 0),
(17, 3, 'customers', 1, 1, 0),
(18, 3, 'sales', 1, 1, 0),
(19, 3, 'reports', 0, 0, 0),
(20, 3, 'stock_movements', 1, 0, 0),
(21, 3, 'advanced_reports', 1, 0, 0),
(22, 4, 'dashboard', 1, 0, 0),
(23, 4, 'products', 1, 0, 0),
(24, 4, 'customers', 1, 0, 0),
(25, 4, 'sales', 1, 0, 0),
(26, 4, 'reports', 1, 0, 0),
(27, 4, 'stock_movements', 1, 0, 0),
(28, 4, 'advanced_reports', 1, 0, 0),
(29, 1, 'file_upload', 1, 1, 1),
(30, 2, 'file_upload', 1, 1, 0),
(31, 1, 'security_tests', 1, 1, 1),
(32, 1, 'performance_monitor', 1, 1, 1),
(36, 1, 'user_management', 1, 1, 1),
(37, 2, 'user_management', 0, 0, 0),
(38, 3, 'user_management', 0, 0, 0),
(39, 4, 'user_management', 0, 0, 0);

-- --------------------------------------------------------

--
-- Görünüm yapısı durumu `stok_durumu_ozet`
-- (Asıl görünüm için aşağıya bakın)
--
CREATE TABLE `stok_durumu_ozet` (
`urun_id` int(11)
,`urun_adi` varchar(255)
,`barkod` varchar(50)
,`toplam_giris` decimal(32,0)
,`toplam_cikis` decimal(32,0)
,`mevcut_stok` decimal(33,0)
,`son_hareket_tarihi` timestamp
);

-- --------------------------------------------------------

--
-- Görünüm yapısı durumu `stok_durum_ozeti`
-- (Asıl görünüm için aşağıya bakın)
--
CREATE TABLE `stok_durum_ozeti` (
`toplam_urun` bigint(21)
,`kritik_stok` decimal(22,0)
,`dusuk_stok` decimal(22,0)
,`normal_stok` decimal(22,0)
,`toplam_stok_degeri` decimal(52,2)
,`ortalama_stok` decimal(14,4)
);

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `stok_hareketleri`
--

CREATE TABLE `stok_hareketleri` (
  `hareket_id` int(11) NOT NULL,
  `urun_id` int(11) NOT NULL,
  `hareket_tipi` enum('giris','cikis','transfer','sayim') NOT NULL,
  `miktar` int(11) NOT NULL,
  `onceki_stok` int(11) NOT NULL,
  `yeni_stok` int(11) NOT NULL,
  `birim_fiyat` decimal(20,2) DEFAULT 0.00,
  `toplam_tutar` decimal(20,2) DEFAULT 0.00,
  `aciklama` text DEFAULT NULL,
  `referans_no` varchar(50) DEFAULT NULL,
  `satis_id` int(11) DEFAULT NULL,
  `kullanici_id` int(11) NOT NULL,
  `tarih` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `stok_hareketleri`
--

INSERT INTO `stok_hareketleri` (`hareket_id`, `urun_id`, `hareket_tipi`, `miktar`, `onceki_stok`, `yeni_stok`, `birim_fiyat`, `toplam_tutar`, `aciklama`, `referans_no`, `satis_id`, `kullanici_id`, `tarih`) VALUES
(1, 2, 'giris', 3, 1, 4, 12.00, 36.00, 's', '1', NULL, 1, '2025-10-11 20:43:14'),
(2, 2, 'cikis', 3, 4, 1, 12.00, 36.00, '1', '3', NULL, 1, '2025-10-11 20:43:35'),
(3, 2, 'giris', 3, 1, 4, 1.00, 3.00, '3', '2', NULL, 1, '2025-10-11 21:05:40'),
(4, 2, 'cikis', 1, 4, 3, 3.00, 3.00, '1', '2', NULL, 1, '2025-10-11 21:16:23'),
(5, 2, 'giris', 2, 3, 5, 211.00, 422.00, '3', '', NULL, 1, '2025-10-12 11:00:15'),
(6, 2, 'cikis', 1, 2, 1, 225.00, 225.00, 'a', '32', NULL, 1, '2025-10-12 11:07:42'),
(7, 2, 'giris', 3, 1, 4, 211.00, 633.00, '1', '2132134', NULL, 1, '2025-10-12 11:21:37'),
(8, 4, 'giris', 5, 0, 5, 12.00, 60.00, '123213', '1234213', NULL, 1, '2025-10-12 11:21:45'),
(9, 4, 'cikis', 2, 5, 3, 32.00, 64.00, '12', '12321', NULL, 1, '2025-10-12 11:21:58'),
(10, 4, 'giris', 12, 0, 12, 12.00, 144.00, 'as', '12321', NULL, 1, '2025-10-12 12:12:19'),
(11, 4, 'giris', 12, 12, 24, 12.00, 144.00, 'asfaf', '1', NULL, 1, '2025-10-12 12:13:01'),
(12, 4, 'giris', 12, 24, 36, 12.00, 144.00, ' - Ref: 213213421', NULL, NULL, 1, '2025-10-12 12:20:10'),
(13, 2, 'giris', 12, 2, 14, 211.00, 2532.00, ' - Ref: 121', NULL, NULL, 1, '2025-10-12 12:25:46');

--
-- Tetikleyiciler `stok_hareketleri`
--
DELIMITER $$
CREATE TRIGGER `update_stock_after_movement` AFTER INSERT ON `stok_hareketleri` FOR EACH ROW BEGIN
    UPDATE `urunler` 
    SET `stok_miktari` = NEW.yeni_stok 
    WHERE `urun_id` = NEW.urun_id;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `stok_sayim`
--

CREATE TABLE `stok_sayim` (
  `sayim_id` int(11) NOT NULL,
  `sayim_tarihi` date NOT NULL,
  `sayim_adi` varchar(255) NOT NULL,
  `aciklama` text DEFAULT NULL,
  `durum` enum('devam_ediyor','tamamlandi','iptal') NOT NULL DEFAULT 'devam_ediyor',
  `kullanici_id` int(11) NOT NULL,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `tamamlanma_tarihi` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `stok_sayim`
--

INSERT INTO `stok_sayim` (`sayim_id`, `sayim_tarihi`, `sayim_adi`, `aciklama`, `durum`, `kullanici_id`, `olusturulma_tarihi`, `tamamlanma_tarihi`) VALUES
(1, '2025-10-11', '12', '311', 'devam_ediyor', 1, '2025-10-11 20:43:47', NULL),
(2, '2025-10-12', '1', '2', 'devam_ediyor', 1, '2025-10-11 21:16:27', NULL);

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `stok_sayim_detay`
--

CREATE TABLE `stok_sayim_detay` (
  `detay_id` int(11) NOT NULL,
  `sayim_id` int(11) NOT NULL,
  `urun_id` int(11) NOT NULL,
  `sistem_stok` int(11) NOT NULL,
  `sayilan_stok` int(11) DEFAULT NULL,
  `fark` int(11) DEFAULT NULL,
  `aciklama` text DEFAULT NULL,
  `sayim_tarihi` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `stok_sayim_detay`
--

INSERT INTO `stok_sayim_detay` (`detay_id`, `sayim_id`, `urun_id`, `sistem_stok`, `sayilan_stok`, `fark`, `aciklama`, `sayim_tarihi`) VALUES
(1, 1, 1, 25, NULL, NULL, NULL, '2025-10-11 20:43:47'),
(2, 1, 2, 1, NULL, NULL, NULL, '2025-10-11 20:43:47'),
(3, 1, 3, 60, NULL, NULL, NULL, '2025-10-11 20:43:47'),
(4, 2, 1, 25, NULL, NULL, NULL, '2025-10-11 21:16:27'),
(5, 2, 2, 3, NULL, NULL, NULL, '2025-10-11 21:16:27'),
(6, 2, 3, 60, NULL, NULL, NULL, '2025-10-11 21:16:27');

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `stok_transfer`
--

CREATE TABLE `stok_transfer` (
  `transfer_id` int(11) NOT NULL,
  `urun_id` int(11) NOT NULL,
  `kaynak_depo` varchar(100) DEFAULT 'Ana Depo',
  `hedef_depo` varchar(100) NOT NULL,
  `miktar` int(11) NOT NULL,
  `aciklama` text DEFAULT NULL,
  `durum` enum('beklemede','onaylandi','iptal') NOT NULL DEFAULT 'beklemede',
  `transfer_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `onay_tarihi` timestamp NULL DEFAULT NULL,
  `kullanici_id` int(11) NOT NULL,
  `onaylayan_kullanici_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `stok_uyari_seviyeleri`
--

CREATE TABLE `stok_uyari_seviyeleri` (
  `uyari_id` int(11) NOT NULL,
  `urun_id` int(11) NOT NULL,
  `minimum_stok` int(11) NOT NULL DEFAULT 0,
  `maksimum_stok` int(11) DEFAULT NULL,
  `kritik_seviye` int(11) DEFAULT NULL,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp(),
  `guncelleme_tarihi` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `stok_uyari_seviyeleri`
--

INSERT INTO `stok_uyari_seviyeleri` (`uyari_id`, `urun_id`, `minimum_stok`, `maksimum_stok`, `kritik_seviye`, `olusturulma_tarihi`, `guncelleme_tarihi`) VALUES
(1, 1, 10, 100, 5, '2025-10-11 19:25:57', '2025-10-11 19:25:57'),
(2, 2, 5, 50, 2, '2025-10-11 19:25:57', '2025-10-11 19:25:57'),
(3, 3, 20, 200, 10, '2025-10-11 19:25:57', '2025-10-11 19:25:57');

-- --------------------------------------------------------

--
-- Tablo için tablo yapısı `urunler`
--

CREATE TABLE `urunler` (
  `urun_id` int(11) NOT NULL,
  `urun_adi` varchar(255) NOT NULL,
  `barkod` varchar(50) DEFAULT NULL,
  `stok_miktari` int(11) NOT NULL DEFAULT 0,
  `alis_fiyati` decimal(20,2) NOT NULL,
  `satis_fiyati` decimal(20,2) NOT NULL,
  `olusturulma_tarihi` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Tablo döküm verisi `urunler`
--

INSERT INTO `urunler` (`urun_id`, `urun_adi`, `barkod`, `stok_miktari`, `alis_fiyati`, `satis_fiyati`, `olusturulma_tarihi`) VALUES
(1, 'Test ÃœrÃ¼n 1', '1234567890123', 0, 10.00, 15.00, '2025-10-11 15:49:50'),
(2, 'deneme ürün', '', 14, 211.00, 225.00, '2025-10-11 15:34:31'),
(3, 'Test ÃœrÃ¼n 3', '3456789012345', 60, 5.00, 8.00, '2025-10-11 15:49:50'),
(4, 'afafa', '123123', 3, 12.00, 32.00, '2025-10-12 11:00:33');

-- --------------------------------------------------------

--
-- Görünüm yapısı `cari_bakiye_ozeti`
--
DROP TABLE IF EXISTS `cari_bakiye_ozeti`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `cari_bakiye_ozeti`  AS SELECT `c`.`cari_id` AS `cari_id`, `c`.`firma_adi` AS `firma_adi`, `c`.`cari_tipi` AS `cari_tipi`, coalesce(sum(case when `ch`.`hareket_tipi` = 'borc' then `ch`.`tutar` else 0 end),0) AS `toplam_borc`, coalesce(sum(case when `ch`.`hareket_tipi` = 'alacak' then `ch`.`tutar` else 0 end),0) AS `toplam_alacak`, coalesce(sum(case when `ch`.`hareket_tipi` = 'borc' then `ch`.`tutar` else -`ch`.`tutar` end),0) AS `bakiye` FROM (`cariler` `c` left join `cari_hareketler` `ch` on(`c`.`cari_id` = `ch`.`cari_id`)) GROUP BY `c`.`cari_id`, `c`.`firma_adi`, `c`.`cari_tipi` ;

-- --------------------------------------------------------

--
-- Görünüm yapısı `hizli_cari_bakiye`
--
DROP TABLE IF EXISTS `hizli_cari_bakiye`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `hizli_cari_bakiye`  AS SELECT `c`.`cari_id` AS `cari_id`, `c`.`firma_adi` AS `firma_adi`, `c`.`cari_tipi` AS `cari_tipi`, `c`.`cari_bakiye` AS `cari_bakiye`, CASE WHEN `c`.`cari_bakiye` > 0 THEN 'Borçlu' WHEN `c`.`cari_bakiye` < 0 THEN 'Alacaklı' ELSE 'Sıfır' END AS `durum` FROM `cariler` AS `c` ;

-- --------------------------------------------------------

--
-- Görünüm yapısı `hizli_stok_durumu`
--
DROP TABLE IF EXISTS `hizli_stok_durumu`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `hizli_stok_durumu`  AS SELECT `u`.`urun_id` AS `urun_id`, `u`.`urun_adi` AS `urun_adi`, `u`.`stok_miktari` AS `stok_miktari`, `u`.`alis_fiyati` AS `alis_fiyati`, `u`.`satis_fiyati` AS `satis_fiyati`, `u`.`satis_fiyati`- `u`.`alis_fiyati` AS `kar_marji`, CASE WHEN `u`.`stok_miktari` <= 5 THEN 'Kritik' WHEN `u`.`stok_miktari` <= 20 THEN 'Düşük' WHEN `u`.`stok_miktari` <= 100 THEN 'Normal' ELSE 'Yüksek' END AS `stok_durumu`, `u`.`stok_miktari`* `u`.`alis_fiyati` AS `toplam_deger` FROM `urunler` AS `u` ;

-- --------------------------------------------------------

--
-- Görünüm yapısı `stok_durumu_ozet`
--
DROP TABLE IF EXISTS `stok_durumu_ozet`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `stok_durumu_ozet`  AS SELECT `u`.`urun_id` AS `urun_id`, `u`.`urun_adi` AS `urun_adi`, `u`.`barkod` AS `barkod`, coalesce(sum(case when `sh`.`hareket_tipi` = 'giri??' then `sh`.`miktar` else 0 end),0) AS `toplam_giris`, coalesce(sum(case when `sh`.`hareket_tipi` = '????k????' then `sh`.`miktar` else 0 end),0) AS `toplam_cikis`, coalesce(sum(case when `sh`.`hareket_tipi` = 'giri??' then `sh`.`miktar` else 0 end),0) - coalesce(sum(case when `sh`.`hareket_tipi` = '????k????' then `sh`.`miktar` else 0 end),0) AS `mevcut_stok`, max(`sh`.`tarih`) AS `son_hareket_tarihi` FROM (`urunler` `u` left join `stok_hareketleri` `sh` on(`u`.`urun_id` = `sh`.`urun_id`)) GROUP BY `u`.`urun_id`, `u`.`urun_adi`, `u`.`barkod` ;

-- --------------------------------------------------------

--
-- Görünüm yapısı `stok_durum_ozeti`
--
DROP TABLE IF EXISTS `stok_durum_ozeti`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `stok_durum_ozeti`  AS SELECT count(0) AS `toplam_urun`, sum(case when `urunler`.`stok_miktari` <= 10 then 1 else 0 end) AS `kritik_stok`, sum(case when `urunler`.`stok_miktari` between 11 and 50 then 1 else 0 end) AS `dusuk_stok`, sum(case when `urunler`.`stok_miktari` > 50 then 1 else 0 end) AS `normal_stok`, sum(`urunler`.`stok_miktari` * `urunler`.`alis_fiyati`) AS `toplam_stok_degeri`, avg(`urunler`.`stok_miktari`) AS `ortalama_stok` FROM `urunler` ;

--
-- Dökümü yapılmış tablolar için indeksler
--

--
-- Tablo için indeksler `cariler`
--
ALTER TABLE `cariler`
  ADD PRIMARY KEY (`cari_id`),
  ADD UNIQUE KEY `firma_adi` (`firma_adi`);

--
-- Tablo için indeksler `cari_hareketler`
--
ALTER TABLE `cari_hareketler`
  ADD PRIMARY KEY (`hareket_id`),
  ADD KEY `cari_id` (`cari_id`),
  ADD KEY `satis_id` (`satis_id`);

--
-- Tablo için indeksler `kullanicilar`
--
ALTER TABLE `kullanicilar`
  ADD PRIMARY KEY (`kullanici_id`),
  ADD UNIQUE KEY `kullanici_adi` (`kullanici_adi`),
  ADD KEY `fk_kullanici_rol` (`rol_id`);

--
-- Tablo için indeksler `performance_log`
--
ALTER TABLE `performance_log`
  ADD PRIMARY KEY (`log_id`),
  ADD KEY `idx_created_at` (`created_at`),
  ADD KEY `idx_execution_time` (`execution_time`),
  ADD KEY `idx_operation_type` (`operation_type`);

--
-- Tablo için indeksler `rapor_gecmisi`
--
ALTER TABLE `rapor_gecmisi`
  ADD PRIMARY KEY (`gecmis_id`),
  ADD KEY `rapor_id` (`rapor_id`),
  ADD KEY `kullanici_id` (`kullanici_id`);

--
-- Tablo için indeksler `rapor_sablonlari`
--
ALTER TABLE `rapor_sablonlari`
  ADD PRIMARY KEY (`rapor_id`),
  ADD KEY `olusturan_kullanici_id` (`olusturan_kullanici_id`);

--
-- Tablo için indeksler `rapor_widgets`
--
ALTER TABLE `rapor_widgets`
  ADD PRIMARY KEY (`widget_id`),
  ADD KEY `olusturan_kullanici_id` (`olusturan_kullanici_id`);

--
-- Tablo için indeksler `roller`
--
ALTER TABLE `roller`
  ADD PRIMARY KEY (`rol_id`),
  ADD UNIQUE KEY `rol_adi` (`rol_adi`);

--
-- Tablo için indeksler `satislar`
--
ALTER TABLE `satislar`
  ADD PRIMARY KEY (`satis_id`),
  ADD KEY `kullanici_id` (`kullanici_id`),
  ADD KEY `cari_id` (`cari_id`);

--
-- Tablo için indeksler `satis_detay`
--
ALTER TABLE `satis_detay`
  ADD PRIMARY KEY (`satis_detay_id`),
  ADD KEY `satis_id` (`satis_id`),
  ADD KEY `urun_id` (`urun_id`);

--
-- Tablo için indeksler `sayfa_yetkileri`
--
ALTER TABLE `sayfa_yetkileri`
  ADD PRIMARY KEY (`yetki_id`),
  ADD UNIQUE KEY `rol_sayfa` (`rol_id`,`sayfa_adi`);

--
-- Tablo için indeksler `stok_hareketleri`
--
ALTER TABLE `stok_hareketleri`
  ADD PRIMARY KEY (`hareket_id`),
  ADD KEY `urun_id` (`urun_id`),
  ADD KEY `kullanici_id` (`kullanici_id`),
  ADD KEY `satis_id` (`satis_id`),
  ADD KEY `hareket_tipi` (`hareket_tipi`),
  ADD KEY `tarih` (`tarih`);

--
-- Tablo için indeksler `stok_sayim`
--
ALTER TABLE `stok_sayim`
  ADD PRIMARY KEY (`sayim_id`),
  ADD KEY `kullanici_id` (`kullanici_id`),
  ADD KEY `sayim_tarihi` (`sayim_tarihi`);

--
-- Tablo için indeksler `stok_sayim_detay`
--
ALTER TABLE `stok_sayim_detay`
  ADD PRIMARY KEY (`detay_id`),
  ADD KEY `sayim_id` (`sayim_id`),
  ADD KEY `urun_id` (`urun_id`);

--
-- Tablo için indeksler `stok_transfer`
--
ALTER TABLE `stok_transfer`
  ADD PRIMARY KEY (`transfer_id`),
  ADD KEY `urun_id` (`urun_id`),
  ADD KEY `kullanici_id` (`kullanici_id`),
  ADD KEY `onaylayan_kullanici_id` (`onaylayan_kullanici_id`);

--
-- Tablo için indeksler `stok_uyari_seviyeleri`
--
ALTER TABLE `stok_uyari_seviyeleri`
  ADD PRIMARY KEY (`uyari_id`),
  ADD UNIQUE KEY `urun_id` (`urun_id`);

--
-- Tablo için indeksler `urunler`
--
ALTER TABLE `urunler`
  ADD PRIMARY KEY (`urun_id`),
  ADD UNIQUE KEY `barkod` (`barkod`);

--
-- Dökümü yapılmış tablolar için AUTO_INCREMENT değeri
--

--
-- Tablo için AUTO_INCREMENT değeri `cariler`
--
ALTER TABLE `cariler`
  MODIFY `cari_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- Tablo için AUTO_INCREMENT değeri `cari_hareketler`
--
ALTER TABLE `cari_hareketler`
  MODIFY `hareket_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=99;

--
-- Tablo için AUTO_INCREMENT değeri `kullanicilar`
--
ALTER TABLE `kullanicilar`
  MODIFY `kullanici_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- Tablo için AUTO_INCREMENT değeri `performance_log`
--
ALTER TABLE `performance_log`
  MODIFY `log_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=33;

--
-- Tablo için AUTO_INCREMENT değeri `rapor_gecmisi`
--
ALTER TABLE `rapor_gecmisi`
  MODIFY `gecmis_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `rapor_sablonlari`
--
ALTER TABLE `rapor_sablonlari`
  MODIFY `rapor_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- Tablo için AUTO_INCREMENT değeri `rapor_widgets`
--
ALTER TABLE `rapor_widgets`
  MODIFY `widget_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- Tablo için AUTO_INCREMENT değeri `roller`
--
ALTER TABLE `roller`
  MODIFY `rol_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- Tablo için AUTO_INCREMENT değeri `satislar`
--
ALTER TABLE `satislar`
  MODIFY `satis_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- Tablo için AUTO_INCREMENT değeri `satis_detay`
--
ALTER TABLE `satis_detay`
  MODIFY `satis_detay_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- Tablo için AUTO_INCREMENT değeri `sayfa_yetkileri`
--
ALTER TABLE `sayfa_yetkileri`
  MODIFY `yetki_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=40;

--
-- Tablo için AUTO_INCREMENT değeri `stok_hareketleri`
--
ALTER TABLE `stok_hareketleri`
  MODIFY `hareket_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- Tablo için AUTO_INCREMENT değeri `stok_sayim`
--
ALTER TABLE `stok_sayim`
  MODIFY `sayim_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- Tablo için AUTO_INCREMENT değeri `stok_sayim_detay`
--
ALTER TABLE `stok_sayim_detay`
  MODIFY `detay_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- Tablo için AUTO_INCREMENT değeri `stok_transfer`
--
ALTER TABLE `stok_transfer`
  MODIFY `transfer_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Tablo için AUTO_INCREMENT değeri `stok_uyari_seviyeleri`
--
ALTER TABLE `stok_uyari_seviyeleri`
  MODIFY `uyari_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- Tablo için AUTO_INCREMENT değeri `urunler`
--
ALTER TABLE `urunler`
  MODIFY `urun_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- Dökümü yapılmış tablolar için kısıtlamalar
--

--
-- Tablo kısıtlamaları `cari_hareketler`
--
ALTER TABLE `cari_hareketler`
  ADD CONSTRAINT `cari_hareketler_ibfk_1` FOREIGN KEY (`cari_id`) REFERENCES `cariler` (`cari_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `cari_hareketler_ibfk_2` FOREIGN KEY (`satis_id`) REFERENCES `satislar` (`satis_id`) ON DELETE SET NULL;

--
-- Tablo kısıtlamaları `kullanicilar`
--
ALTER TABLE `kullanicilar`
  ADD CONSTRAINT `fk_kullanici_rol` FOREIGN KEY (`rol_id`) REFERENCES `roller` (`rol_id`) ON DELETE SET NULL;

--
-- Tablo kısıtlamaları `rapor_gecmisi`
--
ALTER TABLE `rapor_gecmisi`
  ADD CONSTRAINT `rapor_gecmisi_ibfk_1` FOREIGN KEY (`rapor_id`) REFERENCES `rapor_sablonlari` (`rapor_id`),
  ADD CONSTRAINT `rapor_gecmisi_ibfk_2` FOREIGN KEY (`kullanici_id`) REFERENCES `kullanicilar` (`kullanici_id`);

--
-- Tablo kısıtlamaları `rapor_sablonlari`
--
ALTER TABLE `rapor_sablonlari`
  ADD CONSTRAINT `rapor_sablonlari_ibfk_1` FOREIGN KEY (`olusturan_kullanici_id`) REFERENCES `kullanicilar` (`kullanici_id`);

--
-- Tablo kısıtlamaları `rapor_widgets`
--
ALTER TABLE `rapor_widgets`
  ADD CONSTRAINT `rapor_widgets_ibfk_1` FOREIGN KEY (`olusturan_kullanici_id`) REFERENCES `kullanicilar` (`kullanici_id`);

--
-- Tablo kısıtlamaları `satislar`
--
ALTER TABLE `satislar`
  ADD CONSTRAINT `satislar_ibfk_1` FOREIGN KEY (`kullanici_id`) REFERENCES `kullanicilar` (`kullanici_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `satislar_ibfk_2` FOREIGN KEY (`cari_id`) REFERENCES `cariler` (`cari_id`) ON DELETE CASCADE;

--
-- Tablo kısıtlamaları `satis_detay`
--
ALTER TABLE `satis_detay`
  ADD CONSTRAINT `satis_detay_ibfk_1` FOREIGN KEY (`satis_id`) REFERENCES `satislar` (`satis_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `satis_detay_ibfk_2` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`urun_id`);

--
-- Tablo kısıtlamaları `sayfa_yetkileri`
--
ALTER TABLE `sayfa_yetkileri`
  ADD CONSTRAINT `sayfa_yetkileri_ibfk_1` FOREIGN KEY (`rol_id`) REFERENCES `roller` (`rol_id`) ON DELETE CASCADE;

--
-- Tablo kısıtlamaları `stok_hareketleri`
--
ALTER TABLE `stok_hareketleri`
  ADD CONSTRAINT `fk_stok_kullanici` FOREIGN KEY (`kullanici_id`) REFERENCES `kullanicilar` (`kullanici_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_stok_satis` FOREIGN KEY (`satis_id`) REFERENCES `satislar` (`satis_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_stok_urun` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`urun_id`) ON DELETE CASCADE;

--
-- Tablo kısıtlamaları `stok_sayim`
--
ALTER TABLE `stok_sayim`
  ADD CONSTRAINT `fk_sayim_kullanici` FOREIGN KEY (`kullanici_id`) REFERENCES `kullanicilar` (`kullanici_id`) ON DELETE CASCADE;

--
-- Tablo kısıtlamaları `stok_sayim_detay`
--
ALTER TABLE `stok_sayim_detay`
  ADD CONSTRAINT `fk_sayim_detay_sayim` FOREIGN KEY (`sayim_id`) REFERENCES `stok_sayim` (`sayim_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_sayim_detay_urun` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`urun_id`) ON DELETE CASCADE;

--
-- Tablo kısıtlamaları `stok_transfer`
--
ALTER TABLE `stok_transfer`
  ADD CONSTRAINT `fk_transfer_kullanici` FOREIGN KEY (`kullanici_id`) REFERENCES `kullanicilar` (`kullanici_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_transfer_onaylayan` FOREIGN KEY (`onaylayan_kullanici_id`) REFERENCES `kullanicilar` (`kullanici_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_transfer_urun` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`urun_id`) ON DELETE CASCADE;

--
-- Tablo kısıtlamaları `stok_uyari_seviyeleri`
--
ALTER TABLE `stok_uyari_seviyeleri`
  ADD CONSTRAINT `fk_uyari_urun` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`urun_id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
