# Depo ve Stok Takip Sistemi
NOT : En altta görseller mevcut. 

Küçük ve orta ölçekli işletmeler için geliştirilmiş web tabanlı depo ve stok yönetim sistemi. PHP ve MySQL kullanılarak geliştirilmiştir.

## Proje Hakkında

Bu proje, işletmelerin stok takibi, satış yönetimi ve cari hesap takibini tek bir platformdan yapabilmesini sağlar. Özellikle perakende ve toptan satış yapan işletmelerin ihtiyaçlarını karşılamak üzere tasarlanmıştır.

## Özellikler

### Stok Yönetimi
- Ürün ekleme, düzenleme ve silme işlemleri
- Stok giriş ve çıkış hareketleri
- Barkod desteği
- Minimum stok seviyesi uyarıları
- Kritik stok bildirimleri
- Stok sayım işlemleri
- Stok transfer yönetimi
- Detaylı stok hareket geçmişi

### Satış Yönetimi
- Hızlı satış ekranı
- Sepet sistemi
- Kısmi ödeme desteği
- Satış geçmişi ve raporları
- Müşteri bazlı satış takibi
- Otomatik stok düşümü
- Satış iptali ve düzeltme

### Cari Hesap Yönetimi
- Müşteri ve tedarikçi kartları
- Borç/alacak takibi
- Cari hesap hareketleri
- Ödeme alma ve yapma işlemleri
- Detaylı cari ekstreleri
- Bakiye raporları
- FIFO mantığı ile ödeme dağılımı

### Raporlama
- Stok durum raporları
- Satış raporları
- Cari hesap raporları
- Finansal özet raporlar
- Tarih bazlı filtreleme
- Excel ve PDF export (planlanan)

### Kullanıcı Yönetimi
- Rol tabanlı yetkilendirme sistemi
- Admin, Manager, Employee ve Viewer rolleri
- Sayfa bazlı erişim kontrolü
- Kullanıcı aktivite logları
- Güvenli oturum yönetimi

### Sistem Araçları
- Veritabanı analiz ve bakım araçları
- Otomatik yedekleme sistemi
- Veri tutarlılık kontrolleri
- Performans izleme
- Hata loglama sistemi

## Teknolojiler

- **Backend:** PHP 8.0+
- **Veritabanı:** MySQL 5.7+ / MariaDB 10.4+
- **Frontend:** HTML5, CSS3, JavaScript
- **Framework:** Bootstrap 5
- **Kütüphaneler:** Font Awesome, jQuery

## Güvenlik Önlemleri

Proje geliştirilirken güvenlik konusuna özel önem verilmiştir:

### Kimlik Doğrulama ve Yetkilendirme
- Argon2id algoritması ile şifre hashleme
- Session tabanlı kimlik doğrulama
- Otomatik session timeout (30 dakika)
- Rol tabanlı erişim kontrolü (RBAC)
- Sayfa ve işlem bazlı yetki kontrolü

### Veri Güvenliği
- Prepared statements ile SQL injection koruması
- XSS (Cross-Site Scripting) koruması
- CSRF (Cross-Site Request Forgery) token sistemi
- Input sanitization ve validation
- Output escaping
- Güvenli dosya yükleme kontrolleri

### Oturum Güvenliği
- Session fixation koruması
- Session hijacking önlemleri
- Güvenli cookie ayarları
- IP ve User-Agent kontrolü
- Concurrent session yönetimi

### Veritabanı Güvenliği
- Transaction yönetimi ile veri tutarlılığı
- Foreign key constraints
- Trigger'lar ile otomatik veri doğrulama
- Düzenli backup sistemi
- Audit trail (işlem geçmişi)

### Hata Yönetimi
- Detaylı hata loglama
- Kullanıcıya hassas bilgi göstermeme
- Exception handling
- Rollback mekanizmaları

## Kurulum

### Gereksinimler
- PHP 8.0 veya üzeri
- MySQL 5.7+ veya MariaDB 10.4+
- Apache/Nginx web sunucusu
- mod_rewrite modülü (Apache için)

### Adımlar

1. Projeyi klonlayın:
```bash
git clone https://github.com/nullablege/depo-takip-sistemi.git
cd depo-takip-sistemi
```

2. Veritabanını oluşturun:
```sql
CREATE DATABASE depo_stok_takip CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

3. SQL dosyasını import edin:
```bash
mysql -u root -p depo_stok_takip < depo_stok_takip.sql
```

4. Veritabanı bağlantı ayarlarını yapılandırın:
`config/database.php` dosyasındaki bağlantı bilgilerini düzenleyin.

5. Gerekli dizinlere yazma izni verin:
```bash
chmod 755 logs/
chmod 755 backups/
```

6. Web sunucunuzu yapılandırın ve projeyi çalıştırın.

### Varsayılan Giriş Bilgileri

**Admin Kullanıcı:**
- Kullanıcı Adı: `admin`
- Şifre: `admin123`

İlk girişten sonra şifrenizi değiştirmeniz önerilir.

## Kullanım

### Kimler Kullanabilir

**Küçük ve Orta Ölçekli İşletmeler:**
- Perakende mağazalar
- Toptan satış firmaları
- E-ticaret depoları
- Üretim tesisleri
- Dağıtım merkezleri

**Kullanıcı Rolleri:**

1. **Admin (Yönetici)**
   - Tüm sistem ayarlarına erişim
   - Kullanıcı yönetimi
   - Sistem bakım araçları
   - Tüm raporlara erişim

2. **Manager (Müdür)**
   - Satış ve stok işlemleri
   - Cari hesap yönetimi
   - Rapor görüntüleme
   - Ödeme alma/yapma

3. **Employee (Çalışan)**
   - Satış işlemleri
   - Stok görüntüleme
   - Müşteri işlemleri
   - Sınırlı rapor erişimi

4. **Viewer (Görüntüleyici)**
   - Sadece okuma yetkisi
   - Rapor görüntüleme
   - Stok durumu görüntüleme

### Temel İşlemler

**Ürün Ekleme:**
1. Ürünler menüsüne gidin
2. "Yeni Ürün Ekle" butonuna tıklayın
3. Ürün bilgilerini doldurun
4. Kaydedin

**Satış Yapma:**
1. Satış menüsüne gidin
2. Ürünleri sepete ekleyin
3. Müşteri seçin
4. Ödeme tutarını girin
5. Satışı tamamlayın

**Stok Girişi:**
1. Stok Hareketleri menüsüne gidin
2. Stok Giriş sekmesini seçin
3. Ürün ve miktar bilgilerini girin
4. Tedarikçi seçin (opsiyonel)
5. İşlemi kaydedin

**Ödeme Alma:**
1. Raporlar menüsüne gidin
2. Borçlu müşteriyi bulun
3. "Ödeme Al" butonuna tıklayın
4. Ödeme tutarını girin
5. İşlemi onaylayın

## Proje Yapısı

```
depo-takip-sistemi/
├── admin/                  # Yönetim araçları
│   ├── database_analysis.php
│   └── system_test.php
├── config/                 # Yapılandırma dosyaları
│   ├── config.php
│   └── database.php
├── includes/              # Yardımcı sınıflar
│   ├── balance_manager.php
│   ├── stock_manager.php
│   ├── transaction_manager.php
│   ├── security.php
│   └── authorization.php
├── pages/                 # Uygulama sayfaları
│   ├── dashboard.php
│   ├── products.php
│   ├── sales.php
│   ├── reports.php
│   └── stock_movements.php
├── scripts/               # Bakım scriptleri
│   ├── analyze_database.php
│   └── fix_sales_inconsistencies.php
├── logs/                  # Log dosyaları
├── backups/              # Yedek dosyaları
└── assets/               # CSS, JS, resimler
```

## Katkıda Bulunma

Projeye katkıda bulunmak isterseniz:

1. Projeyi fork edin
2. Feature branch oluşturun (`git checkout -b feature/yeniOzellik`)
3. Değişikliklerinizi commit edin (`git commit -am 'Yeni özellik eklendi'`)
4. Branch'inizi push edin (`git push origin feature/yeniOzellik`)
5. Pull Request oluşturun

## Bilinen Sorunlar ve Çözümler

Proje geliştirilirken karşılaşılan ve çözülen önemli sorunlar:

- Transaction yönetimi iyileştirildi
- Bakiye hesaplama mantığı düzeltildi
- F5 ile çift işlem problemi çözüldü
- Stok durumu görüntüleme sorunu giderildi
- Tedarikçi borç yönü düzeltildi

Detaylı bilgi için `MIGRATION_COMPLETED.md` dosyasına bakabilirsiniz.

## Lisans

Bu proje MIT lisansı altında lisanslanmıştır. Detaylar için LICENSE dosyasına bakınız.

## İletişim

Proje Sahibi: [nullablege](https://github.com/nullablege)

Sorularınız veya önerileriniz için GitHub Issues kullanabilirsiniz.

## Teşekkürler

Bu projeyi geliştirirken kullanılan açık kaynak kütüphanelere ve topluluk katkılarına teşekkür ederiz.

---

**Not:** Bu proje eğitim ve ticari kullanım amaçlıdır. Production ortamında kullanmadan önce güvenlik testlerinin yapılması önerilir.

İlgili Görseller : 

Login Sayfası : 
<img width="1013" height="870" alt="image" src="https://github.com/user-attachments/assets/19b19ec0-7589-4097-8e1b-89bce38287dd" />

Dashboard.php 
<img width="3436" height="1221" alt="image" src="https://github.com/user-attachments/assets/72053dd7-3e89-4a99-a8b0-e36d46d3f111" />

Products.php 
<img width="3431" height="1214" alt="image" src="https://github.com/user-attachments/assets/06c37872-69fe-4203-8c8a-004b7048b565" />

Customers.php
<img width="3436" height="1233" alt="image" src="https://github.com/user-attachments/assets/97af0441-28a8-4e6c-ac53-17ebf1442ee6" />

Sales.php 
<img width="3434" height="1218" alt="image" src="https://github.com/user-attachments/assets/453d1baa-1c74-41e2-a80e-bd2ae4917b70" />

Stock_movements.php 
<img width="3431" height="1224" alt="image" src="https://github.com/user-attachments/assets/724c53ba-f1f7-4a5e-894b-27397c8ea3fd" />
<img width="2865" height="749" alt="image" src="https://github.com/user-attachments/assets/e18d1072-4a35-42a6-a038-ff62c9788700" />
<img width="2857" height="546" alt="image" src="https://github.com/user-attachments/assets/7e61b2ee-d458-4524-9b2d-c93ad460fbc1" />
<img width="2485" height="621" alt="image" src="https://github.com/user-attachments/assets/550fced6-0485-4175-9e7b-e3b02a7e5838" />
<img width="2640" height="967" alt="image" src="https://github.com/user-attachments/assets/1f103b46-5f34-4d19-84f9-ba4ac6799a0b" />

Reports.php
<img width="3427" height="1218" alt="image" src="https://github.com/user-attachments/assets/500c1caa-578c-4363-8a69-b0dfe2728224" />

Customer_detail.php 
<img width="3416" height="1219" alt="image" src="https://github.com/user-attachments/assets/6e139f4e-bcab-4e57-a65b-c8eba1020d99" />

Advanced_reports.php 
<img width="3439" height="1222" alt="image" src="https://github.com/user-attachments/assets/62fa364c-cb70-4528-a5ca-15caea28dadd" />
<img width="3419" height="1218" alt="image" src="https://github.com/user-attachments/assets/18e1e894-6b26-4ae4-8e0a-5958a6a7b263" />

Performance_monitor.php 
<img width="3425" height="1222" alt="image" src="https://github.com/user-attachments/assets/99e0214f-c061-46fc-b3cc-0f1e2679f510" />

Database_optimization.php
<img width="3426" height="1209" alt="image" src="https://github.com/user-attachments/assets/5f9e7d01-0078-4829-b11a-49046a846b85" />
<img width="3425" height="1214" alt="image" src="https://github.com/user-attachments/assets/3afc6e41-56c7-4d1f-9f75-144ead2b5b9b" />

Error_management.php
<img width="3438" height="1227" alt="image" src="https://github.com/user-attachments/assets/8a96bebb-c659-4e44-a1ce-9c1b94c7cd70" />

Security_tests.php 
<img width="3426" height="1225" alt="image" src="https://github.com/user-attachments/assets/388863c6-e767-40aa-9d42-09de7ca353a0" />

User_management.php
<img width="3421" height="1213" alt="image" src="https://github.com/user-attachments/assets/5f0c21f6-5409-44ce-9b02-e7d256f79e06" />

